﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "REPORTSPOP")]

public partial class ucReportPopulation : System.Web.UI.UserControl
{
    public void Show()
    {
        wndLoadPopulation.Show();
    }

    public void Close()
    {
        wndLoadPopulation.Hide();
    }

    //base master
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// from date property
    /// </summary>
    public DateTime FromDate
    {
        get
        {
            DateTime dtFrom = dfFromDate.SelectedDate;
            return dtFrom;
        }
    }

    /// <summary>
    /// To date property
    /// </summary>
    public DateTime ToDate
    {
        get
        {
            DateTime dtTo = dfToDate.SelectedDate;
            return dtTo;
        }
    }

    /// <summary>
    /// clinical setting property
    /// </summary>
    public long ClinicalSetting
    {
        get
        {
            if (cboReportClinicalSetting.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportClinicalSetting.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// region property
    /// </summary>
    public long RegionID
    {
        get
        {
            if (cboReportRegion.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportRegion.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// site property
    /// </summary>
    public long SiteID
    {
        get
        {
            if (cboReportSite.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportSite.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// CPA ID property
    /// </summary>
    public long CPAID
    {
        get
        {
            if (cboReportCPA.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportCPA.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }


    /// <summary>
    /// impairment property
    /// </summary>
    public long ImpairmentID
    {
        get
        {
            if (cboReportImpairment.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportImpairment.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// injury property
    /// </summary>
    public long InjuryID
    {
        get
        {
            if (cboReportInjury.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportInjury.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// gender property
    /// </summary>
    public long Gender
    {
        get
        {
            if (cboReportGender.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportGender.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }

    /// <summary>
    /// military status property
    /// </summary>
    public long MilStatusID
    {
        get
        {
            if (cboReportMilStatus.SelectedItem != null)
            {
                return CDataUtils2.ToLong(cboReportMilStatus.SelectedItem.Value);
            }
            else
            {
                return -1;
            }
        }
    }
    

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// load cpa drop down list
    /// </summary>
    public void LoadPopuCPA(string strSiteID)
    {
        //clear the CPA store
        storReportCPA.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the region id and site id
        long lRegionID = -1;
        if (cboReportRegion.SelectedItem == null)
        {
            cboReportCPA.UpdateLayout();
            return;
        }
        else
        {
            lRegionID = CDataUtils2.ToLong(cboReportRegion.SelectedItem.Value);
        }
        long lSiteID = -1;
        if (cboReportSite.SelectedItem == null)
        {
            cboReportCPA.UpdateLayout();
            return;
        }
        else
        {
            lSiteID = CDataUtils2.ToLong(cboReportSite.SelectedItem.Value);
        }

        //load cpa store
        CCPA cpa = new CCPA();
        DataSet dsCPA = cpa.GetCPADS(BaseMstr, lRegionID, lSiteID);
        if (!CDataUtils2.IsEmpty(dsCPA))
        {
            CDataConverter cdc = new CDataConverter();
            string strJSON = cdc.GetJsonDSString(dsCPA);

            storReportCPA.SetDataFromJson(strJSON);
        }

        //clear selections
        cboReportCPA.SelectedItems.Clear();
        cboReportCPA.UpdateSelectedItems();

        cboReportCPA.UpdateLayout();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7281 Load the site dropdown list
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public void LoadSites(string strRegionID)
    {
        //data converter
        CDataConverter cdc = new CDataConverter();

        //clear the combo
        storReportSite.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the region
        CRegionSite site = new CRegionSite(BaseMstr);
        DataSet dsSites = site.GetSiteDS(CDataUtils2.ToLong(strRegionID));

        //load the store from the ds
        string strSiteJSON = cdc.GetJsonDSString(dsSites);
        storReportSite.SetDataFromJson(strSiteJSON);

        //clear the selected items
        cboReportSite.SelectedItems.Clear();
        cboReportSite.UpdateSelectedItems();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7281 user closed the agg report criteria popup
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public void OnOK()
    {
        //todo
        //validate the dates
        DateTime dtFromDate = dfFromDate.SelectedDate;
        DateTime dtToDate = dfToDate.SelectedDate;
        if (dtFromDate.Year == 1 ||
            dtToDate.Year == 1 ||
            (dtFromDate > dtToDate))
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date range!", "Error");
            return;
        }

        //load the criteria label
   /*     lblCriteria.Text = " Criteria: ";
        lblCriteria.Text += CDataUtils2.GetDateAsString(dtFromDate) + " to " + CDataUtils2.GetDateAsString(dtToDate);

        //clinical setting
        lblCriteria.Text += " Clinical Setting: ";
        lblCriteria.Text += cboReportClinicalSetting.SelectedItem.Text;

        //site
        lblCriteria.Text += " Site: ";
        lblCriteria.Text += cboReportSite.SelectedItem.Text;*/

        //load the report_population table
        CReports rep = new CReports();
        rep.LoadPopulation(BaseMstr,
                            this.FromDate,
                            this.ToDate,
                            this.ClinicalSetting,
                            this.RegionID,
                            this.SiteID,
                            this.CPAID,
                            this.ImpairmentID,
                            this.InjuryID,
                            this.Gender,
                            this.MilStatusID);

        wndLoadPopulation.Hide();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //data converter
            CDataConverter cdc = new CDataConverter();
          
            //load the region
            CRegionSite site = new CRegionSite(BaseMstr);
            DataSet dsRegion = site.GetRegionsDS();
            //clear the combo
            cboReportRegion.GetStore().RemoveAll();
            cboReportRegion.Items.Clear();
            //load the store from the ds
            string strRegionJSON = cdc.GetJsonDSString(dsRegion);
            storReportRegion.SetDataFromJson(strRegionJSON);

            //load the impairment
            CReports rep = new CReports();
            DataSet dsImp = rep.GetImpairmentDS(BaseMstr);
            //clear the combo
            cboReportImpairment.GetStore().RemoveAll();
            cboReportImpairment.Items.Clear();
            //load the store from the ds
            string strImpJSON = cdc.GetJsonDSString(dsImp);
            storImpairment.SetDataFromJson(strImpJSON);

            //laod the injuries
            DataSet dsInj = rep.GetInjuryDS(BaseMstr);
            //clear the combo
            cboReportInjury.GetStore().RemoveAll();
            cboReportInjury.Items.Clear();
            //load the store from the ds
            string strInjJSON = cdc.GetJsonDSString(dsInj);
            storInjury.SetDataFromJson(strInjJSON);

            //load the gender
            CStat stat = new CStat(BaseMstr);
            DataSet dsGender = stat.GetDataCollectionDS("_GENDER");
            //clear the combo
            cboReportGender.GetStore().RemoveAll();
            cboReportGender.Items.Clear();
            //load the store from the ds
            string strGenJSON = cdc.GetJsonDSString(dsGender);
            storGender.SetDataFromJson(strGenJSON);

            //add an All item to the top and select it
            Ext.Net.ListItem itmGenderAll = new Ext.Net.ListItem();
            itmGenderAll.Value = Convert.ToString(-1);
            itmGenderAll.Mode = ParameterMode.Raw;
            itmGenderAll.Text = "All";
            cboReportGender.Items.Insert(0, itmGenderAll);
            cboReportGender.SelectedItems.Add(itmGenderAll);
            cboReportGender.UpdateSelectedItems();

            //load the duty status
            DataSet dsDutyStatus = stat.GetDataCollectionDS("_DUTY_STATUS");
            //clear the combo
            cboReportMilStatus.GetStore().RemoveAll();
            cboReportMilStatus.Items.Clear();
            //load the store from the ds
            string strDSJSON = cdc.GetJsonDSString(dsDutyStatus);
            storMilStatus.SetDataFromJson(strDSJSON);

        }
    }
}